# Grafana k6 v1.0 is here! 🎉

After 9 years of iteration and countless community contributions, we're thrilled to announce **Grafana k6 v1.0**. 

While many features and capabilities in this release were introduced gradually in previous versions, **k6 v1.0 marks a turning point**: a commitment to stability, formal support guarantees, and transparency in how we evolve and develop the project from here. This milestone is more than a version number; it's about trust, reliability, and empowering you to test confidently.

## Thank you, k6 community! 🌍

This release wouldn't be possible without you:

- ⭐️ 27000+ GitHub stars.
- 🧠 9000+ git commits.
- 🤝 200+ contributors.
- 🔁 Countless test runs of any scale, in every timezone.

It's been amazing to watch k6 grow from a simple load testing command-line tool into a comprehensive reliability tool, used by teams worldwide and supported by a passionate and dedicated community.

To everyone who filed bugs, built extensions and libraries, or championed k6:️
**Thank you!** You've shaped what k6 is today. 🙇‍♂️

## What's New in k6 1.0?

### 1. Stability You Can Build On

- ✅ **Semantic Versioning**: k6 now follows [Semantic Versioning 2.0](https://semver.org/). Breaking changes will only happen in major releases, with prior deprecation warnings.
- 🔒 **2-Year Support Guarantees**: Every major version will be supported with critical fixes for **at least two years**; upgrade on your schedule.
- 📦 **Public API Surface**: We've established a clearly delineated and supported API surface for the k6 codebase. Extensions, integrations, and projects building on top of the k6 code now have a stable foundation to rely on.

🔎 Read more in our [versioning and stability guarantees](https://grafana.com/docs/k6/latest/reference/versioning-and-stability-guarantees/) guide.

### 2. First-Class TypeScript Support

Write type-safe and maintainable tests—no transpilation needed. Simply save your file with a `.ts` extension and run it directly using `k6 run script.ts`.

```typescript
import http from 'k6/http';  

// PizzaRequest defines the request body format the quickpizza API expects
export interface PizzaRequest {
    maxCaloriesPerSlice: number;
    mustBeVegetarian: boolean;
}

export default function () {  
    const payload: PizzaRequest = {
        maxCaloriesPerSlice: 500, // Type-checked!  
        mustBeVegetarian: true,
    }

  http.post(
    'https://quickpizza.grafana.com/api/pizza',
    JSON.stringify(payload),
    { 
        headers: { 
          "Content-Type": "application/json",
          "Authorization": "Token " + "abcdef0123456789"
        } as Record<string, string>
    });  
}  
```

### 3. Extensions Made Simple

With k6 v1.0, extensions now work out of the box in `k6 cloud run` and `k6 cloud run --local-execution`. Support for `k6 run` is coming soon.

✅ No more xk6 toolchain.
✅ No manual builds.
✅ Import an extension's module and go.

```javascript
import faker from 'k6/x/faker';

export default function () {
  console.log(faker.person.firstName());
}
```

To try the experimental feature, first enable its feature flag, then run it on Grafana Cloud with the following command:

```bash
K6_BINARY_PROVISIONING=true k6 cloud run script.js,
```

or if you want to run it locally and stream the results to Grafana Cloud then use:

```bash
K6_BINARY_PROVISIONING=true k6 cloud run --local-execution script.js
```

### 4. Revamped test summary

The new end-of-test summary makes it easier to **understand results and spot issues**:

* 📊 **Hierarchical output**: Metrics are grouped by scenario, group, and category.
* ✅ **Improved thresholds & checks**: Clearer layout for faster debugging.
* 🔍 **Multiple summary modes**:
  * `compact` (default): big picture results, focusing on essentials.
  * `full`: full picture results, providing granularity.
 
```
k6 run --summary-mode=full script.ts
```

![end-of-test-summary](https://github.com/user-attachments/assets/02984ff9-6ed2-4eb2-9637-daf5058f2de6)

### 5. Quality of Life Upgrades

- Stable modules: `k6/browser`, `k6/net/grpc`, and `k6/crypto` are now production-ready.
- Improved Grafana Cloud integration: Stream local test results to Grafana Cloud with `k6 cloud run --local-execution`.
